/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.blocks;

import com.mojang.serialization.Codec;
import dev.compactmods.crafting.recipes.blocks.ComponentPositionLookupCodec;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;

public class ComponentPositionLookup {
    protected final Map<BlockPos, String> components = new HashMap<BlockPos, String>();
    protected final Map<String, Integer> componentTotals = new HashMap<String, Integer>();
    public static final Codec<ComponentPositionLookup> CODEC = new ComponentPositionLookupCodec();

    public void add(BlockPos location, String component) {
        this.components.putIfAbsent(location, component);
        this.componentTotals.putIfAbsent(component, 0);
        this.componentTotals.put(component, this.componentTotals.get(component) + 1);
    }

    public Collection<String> getComponents() {
        return this.componentTotals.keySet();
    }

    public Stream<BlockPos> getAllPositions() {
        return this.components.keySet().stream();
    }

    public boolean containsLocation(BlockPos location) {
        return this.components.containsKey(location);
    }

    public Map<String, Integer> getComponentTotals() {
        return this.componentTotals;
    }

    void rebuildComponentTotals() {
        this.componentTotals.clear();
        Map<String, Integer> totals = this.components.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.reducing(0, e -> 1, Integer::sum))));
        this.componentTotals.putAll(totals);
    }

    public Optional<String> getRequiredComponentKeyForPosition(BlockPos pos) {
        return Optional.ofNullable(this.components.get(pos));
    }

    public Stream<BlockPos> getPositionsForComponent(String component) {
        if (component == null) {
            return Stream.empty();
        }
        return this.components.entrySet().stream().filter(e -> ((String)e.getValue()).equals(component)).map(Map.Entry::getKey);
    }

    public void remove(String component) {
        Set<BlockPos> positions = this.getPositionsForComponent(component).collect(Collectors.toSet());
        positions.forEach(this.components::remove);
        this.componentTotals.remove(component);
    }
}

